/*
 * Created by SharpDevelop.
 * User: Valued Customer
 * Date: 24/08/2006
 * Time: 13:54
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Drawing;
using System.Windows.Forms;

using XLISetting;

namespace testdotnet1
{
	/// <summary>
	/// Description of MainForm.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.Button button2;
		public MainForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
		}
		
	
		[STAThread]
		public static void Main(string[] args)
		{
			Application.Run(new MainForm());

		}
		

		
		#region Windows Forms Designer generated code
		/// <summary>
		/// This method is required for Windows Forms designer support.
		/// Do not change the method contents inside the source code editor. The Forms designer might
		/// not be able to load this method if it was changed manually.
		/// </summary>
		private void InitializeComponent() {
			this.button2 = new System.Windows.Forms.Button();
			this.button4 = new System.Windows.Forms.Button();
			this.panel1 = new System.Windows.Forms.Panel();
			this.button1 = new System.Windows.Forms.Button();
			this.button3 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// button2
			// 
			this.button2.Enabled = false;
			this.button2.Location = new System.Drawing.Point(496, 242);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(120, 48);
			this.button2.TabIndex = 2;
			this.button2.Text = "Capture";
			this.button2.Click += new System.EventHandler(this.Button2Click);
			// 
			// button4
			// 
			this.button4.Enabled = false;
			this.button4.Location = new System.Drawing.Point(496, 172);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(120, 48);
			this.button4.TabIndex = 4;
			this.button4.Text = "SDK Version";
			this.button4.Click += new System.EventHandler(this.Button4Click);
			// 
			// panel1
			// 
			this.panel1.Location = new System.Drawing.Point(30, 30);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(400, 300);
			this.panel1.TabIndex = 0;
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(496, 32);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(120, 48);
			this.button1.TabIndex = 1;
			this.button1.Text = "Start";
			this.button1.Click += new System.EventHandler(this.Button1Click);
			// 
			// button3
			// 
			this.button3.Enabled = false;
			this.button3.Location = new System.Drawing.Point(496, 102);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(120, 48);
			this.button3.TabIndex = 3;
			this.button3.Text = "Controls";
			this.button3.Click += new System.EventHandler(this.Button3Click);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(640, 366);
			this.Controls.Add(this.button4);
			this.Controls.Add(this.button3);
			this.Controls.Add(this.button2);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.panel1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.MaximumSize = new System.Drawing.Size(646, 388);
			this.Name = "MainForm";
			this.Text = "Sample Capture";
			this.ResumeLayout(false);
		}
		#endregion
		
		XLI_SettingClass CamSet;
		
		void Button1Click(object sender, System.EventArgs e)
		{
			CamSet = new XLI_SettingClass();
			if (CamSet.SelectDevice(1,0,(int)panel1.Handle)==0)
				MessageBox.Show("Camera not found");
			else{
				(sender as Button).Enabled = false;
				button2.Enabled = true;
				button3.Enabled = true;
				button4.Enabled = true;
			}
		}
		
		void Button2Click(object sender, System.EventArgs e)
		{
			int Width,Height,Stride;
			IntPtr buffer;
			CamSet.GetResolution(out Width,out Height);
			Stride = Width*3;
			buffer = (IntPtr)CamSet.Grab(); //Grab an image from the camera
			//Next we build a bitmap from the buffer contents
			Bitmap MyBitmap = new Bitmap(Width, Height, Stride,System.Drawing.Imaging.PixelFormat.Format24bppRgb,buffer);
			MyBitmap.RotateFlip(RotateFlipType.RotateNoneFlipY);
			MyBitmap.Save("hires_image.bmp"); //save image in the same folder as exe.
		}
		
		void Button3Click(object sender, System.EventArgs e)
		{
			CamSet.ShowPropertyPage(Left,Top); //Show the camera controls page	
		}
		
		void Button4Click(object sender, System.EventArgs e)
		{
			int sdkversion = CamSet.GetVal(Txlireg.XLVERSION);
			byte major,minor;
			major = (byte)(sdkversion >> 8);
			minor = (byte)(sdkversion & 0xff);
			//display the current SDK version
			MessageBox.Show("SDK version "+major.ToString()+'.'+minor.ToString());
		}
		
	}
}
